package siarchive.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.sql.SQLException;

import org.junit.After;
import org.junit.Test;

import siarchive.components.Position;
import siarchive.components.Priority;
import siarchive.i18n.Language;
import siarchive.persistence.Account;
import siarchive.persistence.BattleReport;
import siarchive.persistence.DatabaseFactory;
import siarchive.persistence.Note;
import siarchive.persistence.SpyReport;
import siarchive.persistence.dao.AccountDao;
import siarchive.persistence.dao.BattleReportDao;
import siarchive.persistence.dao.SpyReportDao;

public class ReportTest
{
    @After
    public final void tearDown() {
        DatabaseFactory.close();
    }

    @Test
    public void spytest() throws SQLException
    {
        DatabaseFactory.open();
        Account account;
        AccountDao accountDao = DatabaseFactory.getDao( AccountDao.class );
        SpyReport report;
        SpyReportDao reportDao = DatabaseFactory.getDao( SpyReportDao.class );

        account = new Account();
        account.setName( "testAccount1" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );
        report = new SpyReport();
        report.setAccount( account.getId() );
        report.setCreationTime( System.currentTimeMillis() );
        report.setPosition( Position.createId( 1, 1, 1 ) );
        report.setData( "data" );
        report.setFlag( Priority.normal );
        reportDao.save( report );

        account = new Account();
        account.setName( "testAccount2" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );
        report = new SpyReport();
        report.setAccount( account.getId() );
        long time = System.currentTimeMillis();
        report.setCreationTime( time );
        report.setPosition( Position.createId( 1, 1, 2 ) );
        report.setData( "data" );
        report.setFlag( Priority.normal );
        reportDao.save( report );
        DatabaseFactory.commit();


        assertEquals( 2, reportDao.count() );
        assertEquals( 1, reportDao.countByAccount( account.getId() ) );
        report = reportDao.find( account.getId(), Position.createId( 1, 1, 1 ), System.currentTimeMillis() );
        assertEquals( null, report );
        report = reportDao.find( account.getId(), Position.createId( 1, 1, 2 ), time );
        assertNotNull( report );

        Note notes = new Note();
        notes.setText( "some Note" );
        report.setNotes( notes );
        report.setCreationTime( time );
        report.setPosition( Position.createId( 1, 1, 2 ) );
        report.setFlag( Priority.normal );
        reportDao.save( report );
        DatabaseFactory.commit();

        report = new SpyReport();
        report.setAccount( account.getId() );
        report.setRetainNotes( true );
        report.setCreationTime( time );
        report.setPosition( Position.createId( 1, 1, 2 ) );
        report.setFlag( Priority.normal );
        reportDao.save( report );
        DatabaseFactory.commit();

        report = reportDao.find( account.getId(), Position.createId( 1, 1, 2 ), time );
        assertNotNull( report );
        assertNotNull( report.getNotes() );
        assertEquals( "some Note", report.getNotes().getText() );

        account = accountDao.find( "testAccount1" );
        accountDao.delete( account );
        account = accountDao.find( "testAccount2" );
        accountDao.delete( account );
        DatabaseFactory.commit();
        assertEquals( 0, accountDao.count() );
        assertEquals( 0, reportDao.count() );

        DatabaseFactory.commit();
    }

    @Test
    public void battletest() throws SQLException
    {
        DatabaseFactory.open();
        Account account;
        AccountDao accountDao = DatabaseFactory.getDao( AccountDao.class );
        BattleReport report;
        BattleReportDao reportDao = DatabaseFactory.getDao( BattleReportDao.class );

        account = new Account();
        account.setName( "testAccount1" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );
        report = new BattleReport();
        report.setAccount( account.getId() );
        report.setCreationTime( System.currentTimeMillis() );
        report.setPosition( Position.createId( 1, 1, 1 ) );
        report.setData( "data" );
        report.setFlag( Priority.normal );
        reportDao.save( report );

        account = new Account();
        account.setName( "testAccount2" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );
        report = new BattleReport();
        report.setAccount( account.getId() );
        long time = System.currentTimeMillis();
        report.setCreationTime( time );
        report.setPosition( Position.createId( 1, 1, 2 ) );
        report.setData( "data" );
        report.setFlag( Priority.normal );
        reportDao.save( report );
        DatabaseFactory.commit();


        assertEquals( 2, reportDao.count() );
        assertEquals( 1, reportDao.countByAccount( account.getId() ) );
        report = reportDao.find( account.getId(), Position.createId( 1, 1, 1 ), System.currentTimeMillis() );
        assertEquals( null, report );
        report = reportDao.find( account.getId(), Position.createId( 1, 1, 2 ), time );
        assertNotNull( report );

        Note notes = new Note();
        notes.setText( "some Note" );
        report.setNotes( notes );
        report.setCreationTime( time );
        report.setPosition( Position.createId( 1, 1, 2 ) );
        report.setFlag( Priority.normal );
        reportDao.save( report );
        DatabaseFactory.commit();

        report = new BattleReport();
        report.setAccount( account.getId() );
        report.setRetainNotes( true );
        report.setCreationTime( time );
        report.setPosition( Position.createId( 1, 1, 2 ) );
        report.setFlag( Priority.normal );
        reportDao.save( report );
        DatabaseFactory.commit();

        report = reportDao.find( account.getId(), Position.createId( 1, 1, 2 ), time );
        assertNotNull( report );
        assertNotNull( report.getNotes() );
        assertEquals( "some Note", report.getNotes().getText() );

        account = accountDao.find( "testAccount1" );
        accountDao.delete( account );
        account = accountDao.find( "testAccount2" );
        accountDao.delete( account );
        DatabaseFactory.commit();
        assertEquals( 0, accountDao.count() );
        assertEquals( 0, reportDao.count() );

        DatabaseFactory.commit();
    }

}
