package siarchive.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.sql.SQLException;

import org.junit.After;
import org.junit.Test;

import siarchive.components.Status;
import siarchive.i18n.Language;
import siarchive.persistence.Account;
import siarchive.persistence.Alliance;
import siarchive.persistence.DatabaseFactory;
import siarchive.persistence.Note;
import siarchive.persistence.Player;
import siarchive.persistence.dao.AccountDao;
import siarchive.persistence.dao.AllianceDao;
import siarchive.persistence.dao.PlayerDao;

public class PlayerTest
{
    @After
    public final void tearDown() {
        DatabaseFactory.close();
    }

    @Test
    public void test() throws SQLException
    {
        DatabaseFactory.open();
        Account account;
        AccountDao accountDao = DatabaseFactory.getDao( AccountDao.class );
        Alliance alliance;
        AllianceDao allianceDao = DatabaseFactory.getDao( AllianceDao.class );
        Player player;
        PlayerDao playerDao = DatabaseFactory.getDao( PlayerDao.class );

        account = new Account();
        account.setName( "testAccount1" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        account = accountDao.save( account );

        alliance = new Alliance();
        alliance.setAccount( account.getId() );
        // the empty alliance will get ID 0
        alliance.setAllianceId( 0 );
        alliance.setName( "" );
        alliance = allianceDao.save(alliance);

        player = new Player();
        player.setName( "Bluehawk" + 1 );
        player.setAccount( account.getId() );
        player.setAlliance(alliance);
        player.setPlayerId(115);
        player.setPoints( 30000000L + 1 * 1000);
        player.setUpdateTime( System.currentTimeMillis() );
        player.setStatus( Status.enemy );
        player.setSecondaryStatus( null );
        playerDao.save( player );

        account = new Account();
        account.setName( "testAccount2" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );

        alliance = new Alliance();
        alliance.setAccount( account.getId() );
        // the empty alliance will get ID 0
        alliance.setAllianceId( 0 );
        alliance.setName( "" );
        alliance = allianceDao.save(alliance);

        player = new Player();
        player.setName( "Bluehawk" + 2 );
        player.setAccount( account.getId() );
        player.setAlliance(alliance);
        player.setPlayerId(112);
        player.setPoints( 30000000L + 2 * 1000);
        player.setUpdateTime( System.currentTimeMillis() );
        player.setStatus( Status.enemy );
        player.setSecondaryStatus( null );
        playerDao.save( player );
        DatabaseFactory.commit();


        assertEquals( 2, playerDao.count() );
        assertEquals( 1, playerDao.countByAccount( account.getId() ) );
        player = playerDao.find( account.getId(), 115L );
        assertEquals( null, player );
        player = playerDao.find( account.getId(), 112L );
        assertNotNull( player );

        Note notes = new Note();
        notes.setText( "some Note" );
        player.setNotes( notes );
        playerDao.save( player );
        DatabaseFactory.commit();

        player = new Player();
        player.setName( "Bluehawk2" );
        player.setAccount( account.getId() );
        player.setAlliance(alliance);
        player.setUpdateTime( System.currentTimeMillis() );
        player.setRetainNotes( true );
        playerDao.save( player );
        DatabaseFactory.commit();

        player = playerDao.find( account.getId(), 112L );
        assertNotNull( player );
        assertNotNull( player.getNotes() );
        assertEquals( "some Note", player.getNotes().getText() );

        account = accountDao.find( "testAccount1" );
        accountDao.delete( account );
        account = accountDao.find( "testAccount2" );
        accountDao.delete( account );
        DatabaseFactory.commit();
        assertEquals( 0, accountDao.count() );
        assertEquals( 0, playerDao.count() );

        DatabaseFactory.commit();
    }

}
