package siarchive.test;

import static org.junit.Assert.*;

import java.awt.Dimension;
import java.sql.SQLException;

import org.junit.After;
import org.junit.Test;

import siarchive.components.DataTransferMethod;
import siarchive.components.LaFStyle;
import siarchive.persistence.ApplicationConfiguration;
import siarchive.persistence.DatabaseFactory;
import siarchive.persistence.dao.ApplicationConfigurationDao;

public class ConfigurationTest
{
    private static final int defaultWidth = 940;
    private static final int defaultHeight = 715;
    private static final LaFStyle defaultStyle = LaFStyle.black;
    private static final int defaultGalaxyWidth = 820;
    private static final int defaultGalaxyHeight = 640;

    @After
    public final void tearDown() {
        DatabaseFactory.close();
    }

    @Test
    public void test() throws SQLException
    {
        DatabaseFactory.open();
        ApplicationConfiguration config;
        ApplicationConfigurationDao configurationDao = DatabaseFactory.getDao( ApplicationConfigurationDao.class );
        config = configurationDao.get();
        if(config == null)
        {
            config = new ApplicationConfiguration();
        }
        config.setMainFrameSize( new Dimension( defaultWidth, defaultHeight ) );
        config.setShowGalaxyView( false );
        config.setTransferMethod( DataTransferMethod.off );
        config.setLafStyle(defaultStyle);
        configurationDao.save( config );
        DatabaseFactory.commit();
        assertEquals( configurationDao.count(), 1 );
        config = configurationDao.get();

        assertEquals( config.getMainFrameSize().width, defaultWidth );
        assertEquals( config.getMainFrameSize().height, defaultHeight );
        assertEquals( config.getLafStyle(), defaultStyle );

        config = new ApplicationConfiguration();
        config.setMainFrameSize( new Dimension( defaultGalaxyWidth, defaultGalaxyHeight ) );
        config.setTransferMethod( DataTransferMethod.off );
        config.setLafStyle( defaultStyle );
        configurationDao.save( config );
        DatabaseFactory.commit();
        assertEquals( configurationDao.count(), 1 );

        DatabaseFactory.commit();
    }

}
