package siarchive.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.sql.SQLException;

import org.junit.After;
import org.junit.Test;

import siarchive.i18n.Language;
import siarchive.persistence.Account;
import siarchive.persistence.Alliance;
import siarchive.persistence.DatabaseFactory;
import siarchive.persistence.Note;
import siarchive.persistence.dao.AccountDao;
import siarchive.persistence.dao.AllianceDao;

public class AllianceTest
{
    @After
    public final void tearDown() {
        DatabaseFactory.close();
    }


    @Test
    public void test() throws SQLException
    {
        DatabaseFactory.open();
        Account account;
        AccountDao accountDao = DatabaseFactory.getDao( AccountDao.class );
        Alliance alliance;
        AllianceDao allianceDao = DatabaseFactory.getDao( AllianceDao.class );

        account = new Account();
        account.setName( "testAccount1" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );
        alliance = new Alliance("42");
        alliance.setAccount( account.getId() );
        alliance.setAllianceId( 52 );
        alliance.setUpdateTime( System.currentTimeMillis() );
        allianceDao.save( alliance );

        account = new Account();
        account.setName( "testAccount2" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );
        alliance = new Alliance("Mostly Harmless");
        alliance.setAccount( account.getId() );
        alliance.setAllianceId(42);
        alliance.setUpdateTime( System.currentTimeMillis() );
        allianceDao.save( alliance );
        DatabaseFactory.commit();


        assertEquals( 2, allianceDao.count() );
        assertEquals( 1, allianceDao.countByAccount( account.getId() ) );
        alliance = allianceDao.find( account.getId(), 52L );
        assertEquals( null, alliance );
        alliance = allianceDao.find( account.getId(), 42L );
        assertNotNull( alliance );

        Note notes = new Note();
        notes.setText( "some Note" );
        alliance.setNotes( notes );
        allianceDao.save( alliance );
        DatabaseFactory.commit();

        alliance = new Alliance("Mostly Harmless");
        alliance.setAccount( account.getId() );
        alliance.setRetainNotes( true );
        allianceDao.save( alliance );
        DatabaseFactory.commit();

        alliance = allianceDao.find( account.getId(), 42L );
        assertNotNull( alliance );
        assertNotNull( alliance.getNotes() );
        assertEquals( "some Note", alliance.getNotes().getText() );

        account = accountDao.find( "testAccount1" );
        accountDao.delete( account );
        account = accountDao.find( "testAccount2" );
        accountDao.delete( account );
        DatabaseFactory.commit();
        assertEquals( 0, accountDao.count() );
        assertEquals( 0, allianceDao.count() );

        DatabaseFactory.commit();
    }

}
