package siarchive.test;

import static org.junit.Assert.assertEquals;

import java.sql.SQLException;
import java.util.List;

import org.junit.After;
import org.junit.Test;

import siarchive.i18n.Language;
import siarchive.persistence.Account;
import siarchive.persistence.DatabaseFactory;
import siarchive.persistence.dao.AccountDao;

public class AccountTest
{
    @After
    public final void tearDown() {
        DatabaseFactory.close();
    }


    @Test
    public void test() throws SQLException
    {
        DatabaseFactory.open();
        Account account;
        AccountDao accountDao = DatabaseFactory.getDao( AccountDao.class );
        account = new Account();
        account.setName( "TestAccounT" );
        account.setLanguage( Language.russian );
        account.setIndex( 2 );
        account.setDefault( true );
        accountDao.save( account );

        account = new Account();
        account.setName( "testAccount" );
        account.setLanguage( Language.english );
        account.setIndex( 3 );
        account.setDefault( false );
        accountDao.save( account );

        account = new Account();
        account.setName( "TestaccounT" );
        account.setLanguage( Language.german );
        account.setIndex( 1 );
        account.setDefault( false );
        accountDao.save( account );
        DatabaseFactory.commit();

        assertEquals( 3, accountDao.count() );
        List<Account> list = accountDao.find();
        assertEquals( 1, list.get( 0 ).getIndex() );
        assertEquals( 2, list.get( 1 ).getIndex() );
        assertEquals( 3, list.get( 2 ).getIndex() );

        account = list.get( 0 );
        assertEquals( Language.german, account.getLanguage() );
        assertEquals( "TestaccounT", account.getName() );
        account.setLanguage( Language.english );
        accountDao.save( account );
        DatabaseFactory.commit();

        account = accountDao.find( "testAccount" );
        assertEquals( Language.english, account.getLanguage() );
        accountDao.delete( account );
        account = accountDao.find( "TestAccounT" );
        accountDao.delete( account );
        account = accountDao.find( "TestaccounT" );
        accountDao.delete( account );
        DatabaseFactory.commit();
        assertEquals( 0, accountDao.count() );

        DatabaseFactory.commit();
    }

}
