/****************************************
 *  COPYRIGHT (C) 2019
 *  Holger Graf
 ****************************************/
package siarchive.tools;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.UnicodeEscaper;

/**
 * @author graf
 *
 */
@SuppressWarnings("deprecation")
public class EscapeUtils {

    public static String unescapeHtml4(String input) {
        return StringEscapeUtils.unescapeHtml4(input);
    }

    public static String unescapeJava(String input) {
        return StringEscapeUtils.unescapeJava(input);
    }

    public static String escapeXml(String input) {
        return StringEscapeUtils.ESCAPE_XML.with( UnicodeEscaper.outsideOf( 0x20, 0x528 ) ).translate( input );
    }

    public static String unescapeXml(String input) {
        return unescapeJava(StringEscapeUtils.UNESCAPE_XML.with( UnicodeEscaper.outsideOf( 0x20, 0x528 ) ).translate( input ));
    }
}
