/****************************************
 *  COPYRIGHT (C) 2009
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.event.MouseEvent;

import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

/**
 * @author graf
 *
 */
public class TooltipTableHeader extends JTableHeader
{
    private static final long serialVersionUID = -5084733589389608262L;

    public TooltipTableHeader()
    {
        super();
    }

    public TooltipTableHeader( TableColumnModel cm )
    {
        super( cm );
    }

    @Override
    public String getToolTipText( MouseEvent event )
    {
        String tooltip = null;
        int viewColumn = columnModel.getColumnIndexAtX(event.getX());
        int modelColumn = table.convertColumnIndexToModel(viewColumn);
        tooltip = table.getModel().getColumnName( modelColumn );
        return tooltip;
    }

    
}
