/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.table;

import javax.swing.table.DefaultTableModel;

/**
 * @author graf
 *
 */
public class RowHeaderTableModel extends DefaultTableModel
{
    private static final long serialVersionUID = -1930650885791365159L;
    private int rows;
    /**
     * 
     */
    public RowHeaderTableModel()
    {
        // TODO Auto-generated constructor stub
    }

    
    @Override
    public String getColumnName( int column )
    {
        return "#";
    }

    /**
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    public int getColumnCount()
    {
        return 1;
    }

    /**
     * @see javax.swing.table.TableModel#getRowCount()
     */
    public int getRowCount()
    {
        return rows;
    }

    @Override
    public Class<?> getColumnClass( int columnIndex )
    {
        return Integer.class;
    }


    /**
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */
    public Object getValueAt( int rowIndex, int columnIndex )
    {
        return Integer.valueOf( rowIndex + 1 );
    }

    public boolean isCellEditable(int row, int column)
    {
        return false;
    }

    public void setRows( int rows )
    {
        this.rows = rows;
        fireTableDataChanged();
    }
}
