/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import siarchive.Resources;
import siarchive.components.Priority;

/**
 * @author graf
 *
 */
public class PriorityTableCellRenderer extends AlternateLineTableCellRenderer
{
    private static final long serialVersionUID = -4999038936964819018L;

    @Override
    public Component getTableCellRendererComponent( JTable table, Object value,
                    boolean isSelected, boolean hasFocus, int row, int column )
    {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        Icon icon = null;
        if( value instanceof Priority )
        {
            setText( "" );
            switch( (Priority)value )
            {
                case low:
                    icon = Resources.getIcon( "/bubble-low.png" );
                    break;
                case normal:
                    icon = Resources.getIcon( "/bubble-normal.png" );
                    break;
                case high:
                    icon = Resources.getIcon( "/bubble-high.png" );
                    break;
            }
        }
        setHorizontalAlignment( SwingConstants.CENTER );
        setIcon( icon );
        return this;
    }
    
}
