/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Color;
import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingConstants;

import siarchive.Resources;
import siarchive.components.Priority;

/**
 * @author graf
 *
 */
public class PriorityListCellRenderer extends DefaultListCellRenderer
{
    private static final long serialVersionUID = -4999038936964819018L;
    
    private Color background = null;

    @Override
    public Component getListCellRendererComponent( JList list, Object value, int index, boolean isSelected, boolean cellHasFocus )
    {
        super.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus );
        Icon icon = null;
        if( background != null )
        {
            setBackground( background );
        }
        if( value instanceof Priority )
        {
            setText( "" );
            switch( (Priority)value )
            {
                case low:
                    icon = Resources.getIcon( "/bubble-low.png" );
                    break;
                case normal:
                    icon = Resources.getIcon( "/bubble-normal.png" );
                    break;
                case high:
                    icon = Resources.getIcon( "/bubble-high.png" );
                    break;
            }
        }
        if( icon != null )
        {
            setHorizontalAlignment( SwingConstants.CENTER );
            setIcon( icon );
        }
        return this;
    }

    public void setListBackground( Color background )
    {
        this.background = background;
    }
}
