/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.JTable;

/**
 * @author graf
 *
 */
public class PositionRenderer extends AlternateLineTableCellRenderer
{
    private static final long serialVersionUID = 2791643082756476431L;

    private final boolean showPlanets;

    public PositionRenderer() {
        this(false);
    }

    public PositionRenderer(boolean showPlanets) {
        this.showPlanets = showPlanets;
    }

    @Override
    public Component getTableCellRendererComponent( JTable table, Object value, boolean isSelected,
                                                    boolean hasFocus, int row, int column ) {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        if( value instanceof Number ) {
            String position = formatPosition( ((Number)value).intValue() );
            setText( position );
        }
        return this;
    }

    private String formatPosition(int position) {
        StringBuilder sb = new StringBuilder();
        if( position == 0 ) {
            return sb.toString();
        }
        sb.append( '[' );
        sb.append( pad( position / 100000 ) );
        sb.append( ':' );
        sb.append( pad( (position % 100000) / 100 ) );
        if(showPlanets) {
            sb.append( ':' );
            sb.append( pad( position % 100 ) );
        }
        sb.append( ']' );
        return sb.toString();
    }

    private String pad( int value ) {
        StringBuilder sb = new StringBuilder();
        if( value < 10 ) {
            sb.append( '0' );
        }
        sb.append( value );
        return sb.toString();
    }

}
