/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.SwingConstants;

import siarchive.DataManager;

/**
 * @author graf
 *
 */
public class PointsRenderer extends AlternateLineTableCellRenderer
{
    private static final long serialVersionUID = 2791643082756476431L;

    @Override
    public Component getTableCellRendererComponent( JTable table, Object value,
                    boolean isSelected, boolean hasFocus, int row, int column )
    {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        if( value instanceof Number )
        {
            String points = DataManager.format( ((Number)value).longValue() );
            setHorizontalAlignment( SwingConstants.RIGHT );
            setText( points );
        }
        return this;
    }

}
