/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.JTable;

import siarchive.Resources;
import siarchive.persistence.Note;

/**
 * @author graf
 *
 */
public class NotesTableCellRenderer extends IconTableCellRenderer
{
    private static final long serialVersionUID = -4166242074053684748L;

    @Override
    public Component getTableCellRendererComponent( JTable table, Object value,
                    boolean isSelected, boolean hasFocus, int row, int column )
    {
        if( value instanceof Note )
        {
            Note note = ( Note )value;
            if( note.getText() != null && note.getText().trim().length() > 0 )
            {
                value = Resources.getIcon( "/notes.png" );
            }
        }
        else
        {
            value = "";
        }
        return super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
    }

}
