/****************************************
 *  COPYRIGHT (C) 2024
 *  Holger Graf
 ****************************************/
package siarchive.table;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/**
 *
 */
public class MinimumRowHeightTable extends JTable {

    private static final long serialVersionUID = 3355832462722913914L;

    // minimum row height
    private final int preferredHeight = 18;

    /**
     *
     */
    public MinimumRowHeightTable() {
    }

    /**
     * @param dm
     */
    public MinimumRowHeightTable( TableModel dm ) {
        super(dm);
    }

    /**
     * @param dm
     * @param cm
     */
    public MinimumRowHeightTable( TableModel dm, TableColumnModel cm ) {
        super(dm, cm);
    }

    /**
     * @param dm
     * @param cm
     * @param sm
     */
    public MinimumRowHeightTable( TableModel dm, TableColumnModel cm,
                    ListSelectionModel sm ) {
        super(dm, cm, sm);
    }

    @Override
    public int getRowHeight() {
        return preferredHeight;
    }

}
