/****************************************
 *  COPYRIGHT (C) 2010, 2023
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingConstants;

/**
 * @author graf
 *
 */
public class IconTableCellRenderer extends AlternateLineTableCellRenderer
{
    /**
     *
     */
    private static final long serialVersionUID = 3188162716117784007L;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        setHorizontalAlignment( SwingConstants.CENTER );
        if( value instanceof Icon )
        {
            setText( "" );
            setIcon( (Icon )value );
        }
        else
        {
            setIcon( null );
        }
        return this;
    }

}
