/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;
import java.awt.Font;

import javax.swing.JTable;

/**
 * @author graf
 *
 */
public class FontTableCellRenderer extends AlternateLineTableCellRenderer
{
    private static final long serialVersionUID = -4462904629005503080L;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
        if( value instanceof Font )
        {
            Font font = ( Font )value;
            value = font.getName();
            super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
            setFont( font );
        }
        return this;
    }

}
