/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;
import javax.swing.JTable;

import siarchive.components.Fleet;

/**
 * @author graf
 *
 */
public class FleetTableCellRenderer extends AlternateLineTableCellRenderer
{
    /**
     *
     */
    private static final long serialVersionUID = 3188162716117784007L;

    public FleetTableCellRenderer() {}

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        if( value instanceof Fleet && table.getModel() instanceof FleetRenderer ) {
            String rv = ((FleetRenderer)table.getModel()).renderFleetOneLine( (Fleet)value );
            if(rv != null) {
                setText(rv);
            }
            else {
                setText( "" );
            }
        }
        return this;
    }

}
