/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTable;

import siarchive.Resources;
import siarchive.components.Cost;

/**
 * @author graf
 *
 */
public class DebrisTableCellRenderer extends AlternateLineTableCellRenderer
{
    /**
     * 
     */
    private static final long serialVersionUID = 3188162716117784007L;

    private Icon icon;
    
    public DebrisTableCellRenderer()
    {
        icon = Resources.getIcon( "/debris.png" );
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        if( value instanceof Cost )
        {
            setText( "" );
            setIcon( icon );
        }
        else
        {
            setIcon( null );
        }
        return this;
    }

}
