/****************************************
 *  COPYRIGHT (C) 2012-2024
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

public class CheckBoxTableCellRenderer extends JCheckBox implements TableCellRenderer
{
    private static final long serialVersionUID = 5084323263039961046L;
    private TableCellRenderer delegate;
    private Icon selectedIcon = null;
    private Icon unselectedIcon = null;
    private JLabel canvas;

    public CheckBoxTableCellRenderer() {
        this.delegate = new AlternateLineTableCellRenderer();
        this.canvas = new JLabel();
        super.setHorizontalAlignment( SwingConstants.CENTER );
        canvas.setHorizontalAlignment( SwingConstants.CENTER );
        canvas.setOpaque( true );
        setOpaque( false );
    }

    @Override
    public void setHorizontalAlignment( int alignment )
    {
        super.setHorizontalAlignment( alignment );
        if( canvas != null ) {
            canvas.setHorizontalAlignment( alignment );
        }
    }

    public CheckBoxTableCellRenderer( Icon selectedIcon, Icon unselectedIcon )
    {
        this();
        this.selectedIcon = selectedIcon;
        this.unselectedIcon = unselectedIcon;
    }

    public Component getTableCellRendererComponent (JTable table, Object value,
                    boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color bg = c.getBackground();
        // Configure the component with the specified value
        setSelected( Boolean.parseBoolean( value.toString() ) );
        Icon icon = null;
        if( selectedIcon != null && unselectedIcon != null ) {
            if( value instanceof Boolean ) {
                icon = ( isSelected() ) ? selectedIcon : unselectedIcon;
            }
        }
        else {
            Dimension d = getPreferredSize();
            BufferedImage image = new BufferedImage( d.width, d.height, BufferedImage.TYPE_INT_ARGB );
            Graphics g = image.getGraphics();
            // stupid substance checkbox paints only itself, not the surrounding space, DIY
            g.translate( d.width / 2, d.height / 2 );
            this.paintComponent( g );
            icon = new ImageIcon( image );
        }
        canvas.setBackground( bg );
        canvas.setIcon( icon );
        return canvas;
    }
}
