/****************************************
 *  COPYRIGHT (C) 2008-2024
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class ButtonTableCellRenderer extends DefaultTableCellRenderer
{
    private static final long serialVersionUID = 2969212083852732741L;

    public ButtonTableCellRenderer()
    {
        setOpaque(true);
        setHorizontalAlignment( SwingConstants.LEFT );
        setFont( getFont().deriveFont( Font.PLAIN ) );
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
        // configure colors and border
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color fg = ( isSelected ) ? Color.blue.brighter() : table.getForeground();
        setForeground( fg );
        return this;
    }


    @Override
    public Border getBorder() {
        Border border = super.getBorder();
        if( border != null ) {
            Insets in = border.getBorderInsets(this);
            border = BorderFactory.createEmptyBorder(in.top, in.left + 2, in.bottom, in.right + 2);
        }
        return border;
    }

    @Override
    public void paint(Graphics g) {
        JButton button = new JButton();
        button.setOpaque(true);
        button.setText(getText());
        button.setHorizontalAlignment(getHorizontalAlignment());
        button.setHorizontalTextPosition(getHorizontalTextPosition());
        button.setIcon(getIcon());
        button.setForeground(getForeground());
        button.setBackground(getBackground());
        button.setBorder(getBorder());
        button.setSize(getWidth() + 2, getHeight() + 4);
        g.translate(-1, -2);
        button.paint(g);
    }
}
