/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import siarchive.Resources;
import siarchive.components.BlackHoleLevel;

/**
 * @author graf
 *
 */
public class BlackHoleTableCellRenderer extends AlternateLineTableCellRenderer
{
    private static final long serialVersionUID = -4999038936964819018L;

    @Override
    public Component getTableCellRendererComponent( JTable table, Object value,
                    boolean isSelected, boolean hasFocus, int row, int column )
    {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        Icon icon = null;
        if( value instanceof BlackHoleLevel ) {
            setText( "" );
            String path = new StringBuilder()
                            .append("/blackhole")
                            .append(((BlackHoleLevel)value).getLevel())
                            .append(".png.resized")
                            .toString();
            icon = Resources.getIcon( path );
        }
        setHorizontalAlignment( SwingConstants.CENTER );
        setIcon( icon );
        return this;
    }

}
