/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingConstants;

import siarchive.Resources;
import siarchive.components.BlackHoleLevel;
import siarchive.components.EnumWrapper;

/**
 * @author graf
 *
 */
public class BlackHoleLevelListCellRenderer extends DefaultListCellRenderer
{
    private static final long serialVersionUID = -4999038936964819018L;

    @Override
    public Component getListCellRendererComponent( JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus )
    {
        super.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus );
        Icon icon = null;
        if( value instanceof EnumWrapper<?>) {
            @SuppressWarnings("unchecked")
            BlackHoleLevel level = ((EnumWrapper<BlackHoleLevel>)value).getBase();
            if(level != BlackHoleLevel.all) {
                setText( "" );
                String path = new StringBuilder()
                                .append("/blackhole")
                                .append(level.getLevel())
                                .append(".png.resized")
                                .toString();
                icon = Resources.getIcon( path );
            }
        }
        if( icon != null ) {
            setHorizontalAlignment( SwingConstants.CENTER );
            setIcon( icon );
        }
        return this;
    }
}
