/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingConstants;

import siarchive.Resources;
import siarchive.components.AttackStatus;
import siarchive.components.EnumWrapper;

/**
 * @author graf
 *
 */
public class AttackStatusListCellRenderer extends DefaultListCellRenderer
{
    private static final long serialVersionUID = -4999038936964819018L;

    @Override
    public Component getListCellRendererComponent( JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus )
    {
        super.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus );
        Icon icon = null;
        if( value instanceof EnumWrapper<?>) {
            @SuppressWarnings("unchecked")
            AttackStatus status = ((EnumWrapper<AttackStatus>)value).getBase();
            switch(status) {
                case attacked:
                    setText( "" );
                    icon = Resources.getIcon( "/swords.png");
                    break;
                case notattacked:
                    setText( "" );
                    icon = Resources.getIcon( "/peace.png");
                    break;
                default:
                    break;
            }
        }
        if( icon != null ) {
            setHorizontalAlignment( SwingConstants.CENTER );
            setIcon( icon );
        }
        return this;
    }
}
