/****************************************
 *  COPYRIGHT (C) 2008-2024
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AlternateLineTableCellRenderer extends DefaultTableCellRenderer
{
    private static final long serialVersionUID = 550851450050603301L;
    private static double FACTOR = 0.9;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
        Component renderer = super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        Color bg = table.getBackground();

        if( value instanceof JComponent )
        {
            renderer = ( Component )value;
        }
        else if( !isSelected )
        {
            if( row % 2 == 0 )
            {
                renderer.setBackground( darker( bg ) );
            }
            else
            {
                renderer.setBackground( lighter( bg ) );
            }
        }
        return renderer;
    }

    public static Color darker( Color c )
    {
        return new Color(
            Math.max((int)( c.getRed()   * FACTOR ), 0 ),
            Math.max((int)( c.getGreen() * FACTOR ), 0 ),
            Math.max((int)( c.getBlue()  * FACTOR ), 0 )
        );
    }

    public static Color lighter( Color c )
    {
        return new Color(
            c.getRed(),
            c.getGreen(),
            c.getBlue()
        );
    }

}
