/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.table;

import java.awt.Component;

import javax.swing.JTable;

import siarchive.persistence.Alliance;

/**
 * @author graf
 *
 */
public class AllianceCellRenderer extends AlternateLineTableCellRenderer
{
    private static final long serialVersionUID = 4325019266377370024L;

    @Override
    public Component getTableCellRendererComponent( JTable table, Object value,
                    boolean isSelected, boolean hasFocus, int row, int column )
    {
        super.getTableCellRendererComponent( table, value, isSelected, hasFocus, row, column );
        if( value instanceof Alliance )
        {
            setText( ((Alliance)value).getName() );
        }
        return this;
    }

}
