/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import siarchive.DataManager;
import siarchive.MainFrame;
import siarchive.Resources;
import siarchive.components.ClosableTabbedPane;
import siarchive.components.ModulePane;

/**
 * @author graf
 *
 */
public abstract class SummaryPane extends JPanel implements ModulePane
{
    private static final long serialVersionUID = 5648446370033603635L;
    protected MainFrame parent;
    protected JTabbedPane pane = new ClosableTabbedPane(Resources.getIcon("/close.png"));
    protected DataManager dataManager;
    protected JPanel center;

    private JButton button = new JButton();
    private int index = 0;


    /**
     * @param parent
     */
    public SummaryPane( MainFrame parent )
    {
        super();
        this.parent = parent;
        this.dataManager = parent.getDataManager();
        setLayout( new BorderLayout() );
        setBorder( null );
        JPanel upper = new JPanel( new BorderLayout() );
        upper.setBorder( BorderFactory.createEtchedBorder( EtchedBorder.LOWERED ) );
        JPanel left = new JPanel( new GridLayout( 1, 1, 12, 4 ) );
        left.setBorder( new EmptyBorder( 8, 4, 8, 4) );
        left.add( button );
        button.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent e )
            {
                actionNew();
            }

        });

        upper.add( left, BorderLayout.WEST );
        add( upper, BorderLayout.NORTH );

        center = createCenterPanel();
        add( center, BorderLayout.CENTER );

        actionNew();
    }

    protected abstract JPanel createCenterPanel();

    protected abstract void actionNew();

    public void update()
    {
        updateLabel();
        if( parent.getDataManager().getActiveAccount() != null )
        {
            center.setVisible( true );
            // propagate update
            Component c = pane.getSelectedComponent();
            if( c instanceof ModulePane )
            {
                ((ModulePane)c).update();
                //System.out.println( "update pane " + c.getClass().getSimpleName() );
            }
        }
        else
        {
            center.setVisible( false );
        }
    }

    private void updateLabel()
    {
        button.setText( dataManager.getI18nText( "New" ) );
    }

    public String getTitle()
    {
        if(pane.getTabCount() == 0) {
            index = 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append( '(' )
          .append(  ++index )
          .append( ')' );
        return sb.toString();
    }

}
