/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.search;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import siarchive.MainFrame;
import siarchive.components.Position;
import siarchive.persistence.Alliance;
import siarchive.persistence.Player;

/**
 * @author graf
 *
 */
public class PlanetSummaryPane extends SummaryPane
{
    private static final long serialVersionUID = 5648446370033603635L;

    /**
     * @param parent
     */
    public PlanetSummaryPane( MainFrame parent )
    {
        super( parent );
    }

    protected JPanel createCenterPanel()
    {
        JPanel panel = new JPanel( new BorderLayout() );

        panel.add( pane, BorderLayout.CENTER );
        return panel;
    }

    protected void actionNew()
    {
        initPane();
        update();
    }

    public void actionNew( Position position )
    {
        initPane().openPosition( position );
        update();
    }

    public void actionNew( Player player )
    {
        initPane().openPlayer( player );
        update();
    }

    public void actionNew( Alliance alliance )
    {
        initPane().openAlliance( alliance );
        update();
    }

    private PlanetPane initPane() {
        PlanetPane planetPane = new PlanetPane( parent );
        pane.addTab( getTitle(), planetPane );
        return planetPane;
    }
}
