/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.search;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import siarchive.MainFrame;

/**
 * @author graf
 *
 */
public class BlackHoleSummaryPane extends SummaryPane {

    private static final long serialVersionUID = 3425767816812719611L;

    public BlackHoleSummaryPane( MainFrame parent ) {
        super(parent);
    }

    /**
     * @see siarchive.search.SummaryPane#createCenterPanel()
     */
    @Override
    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel( new BorderLayout() );
        panel.add( pane, BorderLayout.CENTER );
        return panel;
    }

    /**
     * @see siarchive.search.SummaryPane#actionNew()
     */
    @Override
    protected void actionNew()
    {
        initPane();
        update();
    }

    private BlackHolePane initPane() {
        BlackHolePane blackHolePane = new BlackHolePane( parent );
        pane.addTab( getTitle(), blackHolePane );
        return blackHolePane;
    }

}
