/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.search;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import siarchive.MainFrame;
import siarchive.persistence.Planet;

/**
 * @author graf
 *
 */
public class BattleReportSummaryPane extends SummaryPane
{
    private static final long serialVersionUID = 5648446370033603635L;
    /**
     * @param parent
     */
    public BattleReportSummaryPane( MainFrame parent )
    {
        super( parent );
    }

    protected JPanel createCenterPanel()
    {
        JPanel panel = new JPanel( new BorderLayout() );
        panel.add( pane, BorderLayout.CENTER );
        return panel;
    }

    public void actionNew( Planet planet )
    {
        initPane().setPlanet( planet );
        update();
    }

    protected void actionNew()
    {
        initPane();
        update();
    }

    private BattleReportPane initPane() {
        BattleReportPane reportPane = new BattleReportPane( parent );
        pane.addTab( getTitle(), reportPane );
        return reportPane;
    }
}
