/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.reports;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;

import javax.swing.JPanel;

/**
 * @author graf
 *
 */
public class StarPanel extends JPanel
{
    private static final long serialVersionUID = -3253924789699863415L;
    private static final int starCount = 400;
    private static final int starSize = 2;

    private int stars;

    public StarPanel()
    {
        this(starCount);
    }

    public StarPanel( int starCount )
    {
        stars = starCount;
        setOpaque(true);
    }

    /**
     * @param isDoubleBuffered
     */
    public StarPanel( boolean isDoubleBuffered )
    {
        super( isDoubleBuffered );
        stars = starCount;
        setOpaque(true);
    }

    /**
     * @param layout
     * @param isDoubleBuffered
     */
    public StarPanel( LayoutManager layout, boolean isDoubleBuffered )
    {
        super( layout, isDoubleBuffered );
        stars = starCount;
        setOpaque(true);
    }

    /**
     * @param layout
     */
    public StarPanel( LayoutManager layout )
    {
        super( layout );
        stars = starCount;
        setOpaque(true);
    }

    @Override
    protected void paintComponent( Graphics g )
    {
        super.paintComponent( g );
        int width = getWidth();
        int height = getHeight();

        g.setColor(Color.black);
        g.fillRect(0, 0, width, height);

        g.setColor( Color.gray );
        for( int i = 0; i < stars; i++ )
        {
            int size = (int)(starSize * ( Math.random() + 1 ));
            int x = (int)(width * Math.random());
            int y = (int)(height * Math.random());
            g.fillOval( x, y, size, size );
        }
    }

}
