/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.reports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

/**
 * @author graf
 *
 */
public class SpyReportField extends JPanel
{
    private static final long serialVersionUID = 5862735256113506354L;

    private JLabel label = new ReportText( new Dimension( 120, 20 ) );
    private JLabel value = new ReportText( new Dimension( 25, 20 ) );
    
    public SpyReportField()
    {
        setLayout( new BorderLayout() );
        label.setHorizontalAlignment( SwingConstants.LEFT );
        value.setHorizontalAlignment( SwingConstants.RIGHT );
        add( label, BorderLayout.CENTER );
        add( value, BorderLayout.EAST );
    }

    public void setLabel( String text )
    {
        this.label.setText( text );
    }

    public void setValue( String text )
    {
        this.value.setText( text );
    }

    @Override
    public void setBackground( Color bg )
    {
        super.setBackground( bg );
        if( label != null && value != null )
        {    
            label.setBackground( bg );
            value.setBackground( bg );
        }
    }

    @Override
    public void setForeground( Color fg )
    {
        super.setForeground( fg );
        if( label != null && value != null )
        {    
            value.setForeground( fg );
            label.setForeground( fg );
        }
    }
    
    
}
