/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.reports;

import java.awt.Dimension;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.SwingConstants;

/**
 * @author graf
 *
 */
public class ReportText extends ReportLabel
{
    private static final long serialVersionUID = -8836371315748928235L;

    private Dimension minimumSize;

    /**
     *
     */
    public ReportText()
    {
        init();
    }

    /**
     *
     */
    public ReportText( Dimension size )
    {
        minimumSize = size;
        init();
    }

    /**
     * @param text
     */
    public ReportText( String text )
    {
        super( text );
        init();
    }

    public void setBold()
    {
        Font font = getFont();
        setFont( font.deriveFont( font.getStyle() ^ Font.BOLD ) );
    }


    @Override
    public Dimension getPreferredSize()
    {
        Dimension size = super.getPreferredSize();
        if( minimumSize != null )
        {
            if( size.width < minimumSize.width )
            {
                size.width = minimumSize.width;
            }
            if( size.height < minimumSize.height )
            {
                size.height = minimumSize.height;
            }
        }
        return size;
    }

    private void init()
    {
        setOpaque( true );
        setBorder( BorderFactory.createEtchedBorder() );
        setHorizontalAlignment( SwingConstants.CENTER );
    }
}
