/****************************************
 *  COPYRIGHT (C) 2024
 *  Holger Graf
 ****************************************/
package siarchive.reports;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.metal.MetalLabelUI;

/**
 *
 */
public class ReportLabel extends JLabel {

    private static final long serialVersionUID = 7551929826709568383L;

    /**
     *
     */
    public ReportLabel() {
        init();
    }

    /**
     * @param text
     */
    public ReportLabel( String text ) {
        super(text);
        init();
    }

    /**
     * @param image
     */
    public ReportLabel( Icon image ) {
        super(image);
        init();
    }

    /**
     * @param text
     * @param horizontalAlignment
     */
    public ReportLabel( String text, int horizontalAlignment ) {
        super(text, horizontalAlignment);
        init();
    }

    /**
     * @param image
     * @param horizontalAlignment
     */
    public ReportLabel( Icon image, int horizontalAlignment ) {
        super(image, horizontalAlignment);
        init();
    }

    /**
     * @param text
     * @param icon
     * @param horizontalAlignment
     */
    public ReportLabel( String text, Icon icon, int horizontalAlignment ) {
        super(text, icon, horizontalAlignment);
        init();
    }

    /**
     * Use a LaF independent UI
     * @see javax.swing.JLabel#setUI(javax.swing.plaf.LabelUI)
     */
    @Override
    public void setUI( LabelUI ui ) {
        final LabelUI iUI = (LabelUI)MetalLabelUI.createUI(this);
        super.setUI(iUI);
    }


    private void init() {
    }
}
