/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.persistence.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import siarchive.components.Priority;
import siarchive.persistence.SpyReport;


/**
 * @author graf
 *
 */
public class SpyReportDao extends ReportDao<SpyReport>
{
    private final String FINDBYDEFENDER = "SELECT * FROM " + getTable() + " WHERE " + getTable() + ".ACCOUNT = ? AND KIND = ? AND POSITION IN "
                    + "( SELECT " + PlanetDao.table + ".POSITION FROM " + PlanetDao.table + " WHERE " + PlanetDao.table + ".OWNER IN "
                    + "( SELECT " + PlayerDao.table + ".ID FROM " + PlayerDao.table + " WHERE " + PlayerDao.table + ".ACCOUNT = ? AND LOWER(" + PlayerDao.table + ".NAME) LIKE ? )"
                    + " )" + ORDERBYCREATIONTIMEASC;
    public List<SpyReport> findByDefender(Long account, String playerNameExpr) throws SQLException
    {
        PreparedStatement find = getConnection().prepareStatement( FINDBYDEFENDER, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
        find.setLong( 1, account );
        find.setString( 2, getKind() );
        find.setLong( 3, account );
        find.setString( 4, sqlSubstitute( playerNameExpr ).toLowerCase() );
        ResultSet resultSet = find.executeQuery();
        List<SpyReport> list = createDTO( resultSet );
        resultSet.close();
        find.close();
        return list;
    }

    private final String FINDBYDEFENDERANDPRIORITY = "SELECT * FROM " + getTable() + " WHERE " + getTable() + ".ACCOUNT = ? AND KIND = ? AND PRIORITY = ? AND POSITION IN "
                    + "( SELECT " + PlanetDao.table + ".POSITION FROM " + PlanetDao.table + " WHERE " + PlanetDao.table + ".OWNER IN "
                    + "( SELECT " + PlayerDao.table + ".ID FROM " + PlayerDao.table + " WHERE " + PlayerDao.table + ".ACCOUNT = ? AND LOWER(" + PlayerDao.table + ".NAME) LIKE ? )"
                    + " )" + ORDERBYCREATIONTIMEASC;
    public List<SpyReport> findByDefender(Long account, String playerNameExpr, Priority priority) throws SQLException
    {
        PreparedStatement find = getConnection().prepareStatement( FINDBYDEFENDERANDPRIORITY, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
        find.setLong( 1, account );
        find.setString( 2, getKind() );
        find.setString( 3, priority.name() );
        find.setLong( 4, account );
        find.setString( 5, sqlSubstitute( playerNameExpr ).toLowerCase() );
        ResultSet resultSet = find.executeQuery();
        List<SpyReport> list = createDTO( resultSet );
        resultSet.close();
        find.close();
        return list;
    }

    private final String FINDBYPLANET = "SELECT * FROM " + getTable() + " WHERE ACCOUNT = ? AND KIND = ? AND LOWER(PLANET) LIKE ?" + ORDERBYCREATIONTIMEASC;
    public List<SpyReport> findByPlanet(Long account, String planetNameExpr) throws SQLException
    {
        PreparedStatement find = getConnection().prepareStatement( FINDBYPLANET, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
        find.setLong( 1, account );
        find.setString( 2, getKind() );
        find.setString( 3, sqlSubstitute( planetNameExpr ).toLowerCase() );
        ResultSet resultSet = find.executeQuery();
        List<SpyReport> list = createDTO( resultSet );
        resultSet.close();
        find.close();
        return list;
    }

    private final String FINDBYPLANETANDPRIORITY = "SELECT * FROM " + getTable() + " WHERE ACCOUNT = ? AND KIND = ? AND LOWER(PLANET) LIKE ? AND PRIORITY = ?" + ORDERBYCREATIONTIMEASC;
    public List<SpyReport> findByPlanetAndPriority(Long account, String planetNameExpr, Priority priority) throws SQLException
    {
        PreparedStatement find = getConnection().prepareStatement( FINDBYPLANETANDPRIORITY, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
        find.setLong( 1, account );
        find.setString( 2, getKind() );
        find.setString( 3, sqlSubstitute( planetNameExpr ).toLowerCase() );
        find.setString( 4, priority.name() );
        ResultSet resultSet = find.executeQuery();
        List<SpyReport> list = createDTO( resultSet );
        resultSet.close();
        find.close();
        return list;
    }

    @Override
    protected List<SpyReport> createDTO( ResultSet resultSet ) throws SQLException
    {
        List<SpyReport> list = new ArrayList<SpyReport>();
        while(resultSet.next())
        {
            Long id = resultSet.getLong( "ID" );
            SpyReport report = readCache(id);
            if(report == null )
            {
                report = new SpyReport();
                fillBaseDTO( report, resultSet );
            }
            list.add(report);
            updateCache( report );
        }
        return list;
    }

    @Override
    protected String getKind()
    {
        return "spy";
    }

    private final String CREATE = "INSERT INTO " + getTable() + " (KIND, ACCOUNT, CREATETIME, POSITION, ISASTEROID, PRIORITY, REPORTDATA, NOTES, PLANET) values ('" + getKind() + "', ?, ?, ?, ?, ?, ?, ?, ?)";
    @Override
    protected PreparedStatement createStatement( SpyReport report ) throws SQLException
    {
        PreparedStatement create = getConnection().prepareStatement( CREATE, Statement.RETURN_GENERATED_KEYS );
        int pos = 1;
        create.setLong( pos++, report.getAccount() );
        create.setLong( pos++, report.getCreationTime() );
        create.setInt( pos++, report.getPosition() );
        create.setBoolean( pos++, report.isAsteroid() );
        String flag = (report.getFlag() != null) ? report.getFlag().name() : null;
        create.setString( pos++, flag );
        create.setString( pos++, report.getData() );
        create.setString( pos++, getNote( report.getNotes() ) );
        create.setString( pos++, report.getPlanetName() );
        return create;
    }

    private final String UPDATE = "UPDATE " + getTable() + " SET ACCOUNT = ?, CREATETIME = ?, POSITION = ?, ISASTEROID = ?, PRIORITY = ?, REPORTDATA = ?, NOTES = ?, PLANET = ? WHERE ID = ? AND KIND = '" + getKind() + "'";
    @Override
    protected PreparedStatement updateStatement( SpyReport report ) throws SQLException
    {
        PreparedStatement update;
        int pos = 1;
        update = getConnection().prepareStatement( UPDATE );
        update.setLong( pos++, report.getAccount() );
        update.setLong( pos++, report.getCreationTime() );
        update.setInt( pos++, report.getPosition() );
        update.setBoolean( pos++, report.isAsteroid() );
        String flag = (report.getFlag() != null) ? report.getFlag().name() : null;
        update.setString( pos++, flag );
        update.setString( pos++, report.getData() );
        update.setString( pos++, getNote( report.getNotes() ) );
        update.setString( pos++, report.getPlanetName() );
        update.setLong( pos++, report.getId() );
        return update;
    }

}
