/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.persistence.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import siarchive.persistence.DbObject;

/**
 * @author graf
 *
 */
public abstract class IdentifierDao<T extends DbObject<T>> extends BaseDao<T>
{
    /**
     * @param cacheSize
     */
    public IdentifierDao( int cacheSize )
    {
        super( cacheSize );
    }

    private final String FINDLOWID = "SELECT MIN(" + identifierColumn() + ") AS MINID FROM " + getTable() + " WHERE ACCOUNT = ?";
    protected Long minId(Long account) throws SQLException
    {
        Long result = null;
        if(account != null)
        {
            PreparedStatement find = getConnection().prepareStatement( FINDLOWID, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
            find.setLong( 1, account );
            ResultSet resultSet = find.executeQuery();
            if(resultSet.next())
            {
                Object o = resultSet.getObject( "MINID" );
                result = (Long)o;
            }
            resultSet.close();
            find.close();
        }
        if( result == null || result.longValue() > maxLowId )
        {
            result = Long.valueOf(  maxLowId );
        }
        return result - 1;
    }

    protected abstract String identifierColumn();
}
