/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.persistence.dao;

import java.awt.Dimension;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import siarchive.components.DataTransferMethod;
import siarchive.components.LaFStyle;
import siarchive.persistence.ApplicationConfiguration;

/**
 * @author graf
 *
 */
public class ApplicationConfigurationDao extends BaseDao<ApplicationConfiguration>
{
    public final static String table = "configuration";

    /**
     * @throws SQLException
     *
     */
    public ApplicationConfigurationDao() throws SQLException
    {
        super(3);
    }

    public ApplicationConfiguration get() throws SQLException
    {
        PreparedStatement get = getConnection().prepareStatement( "SELECT * FROM " + getTable(), ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
        ResultSet resultSet = get.executeQuery();
        List<ApplicationConfiguration> result = createDTO( resultSet );
        resultSet.close();
        get.close();
        // there can be at most 1
        return getFirst( result );
    }

    @Override
    public ApplicationConfiguration get( Long key ) throws SQLException
    {
        // there is no key in ApplicationConfiguration
        return get();
    }

    // there will always be at most one ApplicationConfiguration
    // so this DAO doesn't follow BaseDao rules and overrides save()
    @Override
    public ApplicationConfiguration save(ApplicationConfiguration configuration) throws SQLException
    {
        PreparedStatement save;
        if(count() == 0 )
        {
            save = getConnection().prepareStatement( "INSERT INTO " + getTable() + " (MAINFRAMEWIDTH, MAINFRAMEHEIGHT, SHOWGALAXY, DATATRANSFER, LAFSTYLE) values (?, ?, ?, ?, ?)" );
        }
        else
        {
            save = getConnection().prepareStatement( "UPDATE " + getTable() + " SET MAINFRAMEWIDTH = ?, MAINFRAMEHEIGHT = ?, SHOWGALAXY = ?, DATATRANSFER = ?, LAFSTYLE = ?" );
        }
        Dimension dim = configuration.getMainFrameSize();
        save.setInt( 1, dim.width );
        save.setInt( 2, dim.height );
        save.setBoolean( 3, configuration.isShowGalaxyView() );
        save.setString( 4, configuration.getTransferMethod().name() );
        save.setString( 5, configuration.getLafStyle().name() );
        save.executeUpdate();
        save.close();
        return configuration;
    }

    @Override
    protected String getTable()
    {
        return table;
    }

    @Override
    protected List<ApplicationConfiguration> createDTO( ResultSet resultSet ) throws SQLException
    {
        List<ApplicationConfiguration> list = new ArrayList<ApplicationConfiguration>();
        while (resultSet.next())
        {
            ApplicationConfiguration configuration = new ApplicationConfiguration();
            Dimension dim = new Dimension();
            dim.width = resultSet.getInt( "MAINFRAMEWIDTH" );
            dim.height = resultSet.getInt( "MAINFRAMEHEIGHT" );
            configuration.setMainFrameSize( dim );
            configuration.setShowGalaxyView( resultSet.getBoolean( "SHOWGALAXY" ) );
            configuration.setTransferMethod( DataTransferMethod.valueOf( resultSet.getString( "DATATRANSFER" ) ) );
            configuration.setLafStyle( LaFStyle.valueOf( resultSet.getString( "LAFSTYLE" ) ) );
            list.add( configuration );
        }
        return list;
    }

	@Override
	protected PreparedStatement createStatement(ApplicationConfiguration dbObject) throws SQLException {
		// not needed
		return null;
	}

	@Override
	protected ApplicationConfiguration findUnique(ApplicationConfiguration dbObject) throws SQLException {
		// not needed
		return null;
	}

	@Override
	protected PreparedStatement updateStatement(ApplicationConfiguration dbObject) throws SQLException {
		// not needed
		return null;
	}
}
