/****************************************
 *  COPYRIGHT (C) 2011
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

/**
 * @author graf
 *
 */
public class SQLParser
{
    private static final String sqlComment = "--";
    private static final String eol = ";";

    BufferedReader reader;
    
    public SQLParser(String sqlFile) throws FileNotFoundException
    {
        reader = new BufferedReader( new FileReader( sqlFile ) );
    }

    public void close() throws IOException
    {
        reader.close();
    }
    
    public String getNextStatement() throws IOException
    {
        String result = null;
        String line = null;
        StringBuilder statement = new StringBuilder(); 
        while( (line = reader.readLine()) != null ) {
            int pos = line.indexOf( eol );
            // end of statement and/or comment
            if(pos != -1)
            {
                line = line.substring( 0, pos ).trim();
                // if there is anything left add to the statement 
                if( line.length() > 0 )
                {
                    statement.append( line );
                }
                if(statement.length() > 0)
                {
                    result = statement.toString();
                    break;
                }
            }
            line = line.trim();
            if(line.length() > 0)
            {
                // remove sql comments
                pos = line.indexOf( sqlComment );
                if(pos != -1)
                {
                    line = line.substring( 0, pos );
                }
                // begin or continuation of statement
                statement.append( line.trim() ).append( ' ' );
            }
        }
        return result;
    }
}
