/****************************************
 *  COPYRIGHT (C) 2012, 2023
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import siarchive.components.Position;
import siarchive.components.Priority;

/**
 * @author graf
 *
 */
public abstract class Report<T extends Report<T>> extends DbObject<T>
{
    protected Long account;
    protected long creationTime;
    protected int position;
    protected String planetName;
    protected boolean isAsteroid;
    private Priority flag;
    protected String data;
    private boolean retainNotes;
    private Note notes;

    public Long getAccount()
    {
        return account;
    }

    public void setAccount( Long account )
    {
        this.account = account;
    }

    public long getCreationTime()
    {
        return creationTime;
    }

    public void setCreationTime( long creationTime )
    {
        this.creationTime = creationTime;
    }

    public int getPosition()
    {
        return position;
    }

    public void setPosition( int position )
    {
        this.position = position;
    }

    public void setPosition( String coords )
    {
        setPosition(Position.createId(coords));
    }

    public String getPlanetName()
    {
        return planetName;
    }

    public void setPlanetName(String planetName)
    {
        this.planetName = planetName;
    }

    public boolean isAsteroid()
    {
        return isAsteroid;
    }

    public void setAsteroid( boolean isAstro )
    {
        this.isAsteroid = isAstro;
    }

    public Priority getFlag()
    {
        return flag;
    }

    public void setFlag( Priority flag )
    {
        this.flag = flag;
    }

    public String getData()
	{
		return data;
	}

	public void setData(String data)
	{
		this.data = data;
	}

    public boolean isRetainNotes()
    {
        return retainNotes;
    }

    public void setRetainNotes( boolean retainNotes )
    {
        this.retainNotes = retainNotes;
    }

    public Note getNotes()
    {
        return notes;
    }

    public void setNotes( Note notes )
    {
        this.notes = notes;
    }

    public String getName()
    {
        return getPlanetName();
    }

    @Override
    public boolean equals( Object obj ) {
        // super establishes equality based on ID
        // if it says they are equal, they are
        boolean rv = super.equals( obj );
        if( !rv && obj instanceof Report ) {
            Report<?> that = ( Report<?> )obj;
            rv = getAccount().equals( that.getAccount() )
              && getPosition() == that.getPosition()
              && isAsteroid() == that.isAsteroid()
              && getCreationTime() == that.getCreationTime();
        }
        return rv;
    }

    @Override
    public int hashCode() {
        long hc = getAccount() + (getPosition() << 32) + getCreationTime() + Boolean.hashCode(isAsteroid());
        return Long.hashCode(hc);
    }

    @Override
    public void update( T report ) {
        this.account = report.account;
        this.creationTime = report.creationTime;
        this.isAsteroid = report.isAsteroid;
        this.position = report.position;
        this.planetName = report.planetName;
        this.data = report.data;
    }
}
