/****************************************
 *  COPYRIGHT (C) 2012, 2024
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import siarchive.components.Status;

/**
 * @author graf
 *
 */
public class Player extends DbObject<Player> implements Notable<Player>
{
    private String name;
    private String title;
    private Long account;
    private long playerId = -1L;
    private long points;
    private long spiceValue;
    private String specialization;
    private Alliance alliance;
    private Status status;
    private Status secondaryStatus;
    private long updateTime;
    private boolean retainNotes;
    private Note notes;

    public Long getAccount()
    {
        return account;
    }

    public void setAccount( Long account )
    {
        this.account = account;
    }

    public long getPlayerId()
    {
        return playerId;
    }

    public void setPlayerId( long playerId )
    {
        this.playerId = playerId;
    }

    public String getName()
    {
        return name;
    }

    public void setName( String name )
    {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle( String title ) {
        this.title = title;
    }

    public Alliance getAlliance()
    {
        return alliance;
    }

    public void setAlliance( Alliance alliance )
    {
        this.alliance = alliance;
    }

    public Status getStatus()
    {
        return status;
    }

    public void setStatus(Status status)
    {
        this.status = status;
    }

    public Status getSecondaryStatus()
    {
        return secondaryStatus;
    }

    public void setSecondaryStatus(Status status)
    {
        this.secondaryStatus = status;
    }

    public long getUpdateTime()
    {
        return updateTime;
    }

    public void setUpdateTime( long updateTime )
    {
        this.updateTime = updateTime;
    }

    public boolean isRetainNotes()
    {
        return retainNotes;
    }

    public void setRetainNotes( boolean retainNotes )
    {
        this.retainNotes = retainNotes;
    }

    public Note getNotes()
    {
        return notes;
    }

    public void setNotes( Note notes )
    {
        this.notes = notes;
    }

    public long getPoints()
    {
        return points;
    }

    public void setPoints( long points )
    {
        this.points = points;
    }

    public long getSpiceValue() {
        return spiceValue;
    }

    public void setSpiceValue( long spiceValue ) {
        this.spiceValue = spiceValue;
    }

    public String getSpecialization() {
        return specialization;
    }

    public void setSpecialization( String specialization ) {
        this.specialization = specialization;
    }


    public void update( Player player )
    {
        // don't overwrite newer versions
        if( player.getUpdateTime() > getUpdateTime() )
        {
            this.account = player.account;
            this.name = player.name;
            this.title = player.title;
            // do not update an invalid playerId
            if( player.playerId >= 0 )
            {
                this.playerId = player.playerId;
            }
            this.alliance = player.alliance;
            this.points = player.points;
            this.spiceValue = player.spiceValue;
            this.specialization = player.specialization;
            this.status = player.status;
            this.secondaryStatus = player.secondaryStatus;
            this.updateTime = player.updateTime;
        }
    }

    @Override
    public boolean equals( Object obj )
    {
        // super establishes equality based on ID
        // if it says they are equal, they are
        boolean rv = super.equals( obj );
        if( !rv && obj instanceof Player )
        {
            Player that = ( Player )obj;
            rv = account.equals( that.account ) && ( playerId == that.playerId );
        }
        return rv;
    }

    @Override
    public int hashCode()
    {
        return ( account.hashCode() << 16 ) + Long.valueOf( playerId ).hashCode();
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append( name );
        if( getAlliance() != null && getAlliance().getName().length() > 0 )
        {
            sb.append( " of '" );
            sb.append( getAlliance().getName() );
            sb.append( "'" );
        }
        return sb.toString();
    }
}
