/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import siarchive.components.Cost;
import siarchive.components.Position;

/**
 * @author graf
 *
 */
public class Planet extends DbObject<Planet> implements Notable<Planet>
{
    private Long account;
    private String name;
    private int position;
    private boolean hasAsteroid;
    private boolean isEvent;
    private Player owner;
    private long updateTime;
    private boolean retainNotes;
    private Note notes;

    private long iron;
    private long metal;
    private long kryptonite;
    private long spice;

    public Planet()
    {}

    public String getName()
    {
        return name;
    }

    public void setName( String name )
    {
        this.name = name;
    }

    public int getPosition()
    {
        return position;
    }

    public void setPosition( int position )
    {
        this.position = position;
    }

    public boolean hasAsteroid()
    {
        return hasAsteroid;
    }

    public void setAsteroid( boolean isAstro )
    {
        this.hasAsteroid = isAstro;
    }

    public boolean isEvent() {
        return isEvent;
    }

    public void setEvent( boolean isEvent ) {
        this.isEvent = isEvent;
    }

    public Long getAccount()
    {
        return account;
    }

    public void setAccount( Long account )
    {
        this.account = account;
    }

    public Player getOwner()
    {
        return owner;
    }

    public void setOwner( Player owner )
    {
        this.owner = owner;
    }

    public long getUpdateTime()
    {
        return updateTime;
    }

    public void setUpdateTime( long updateTime )
    {
        this.updateTime = updateTime;
    }

    public boolean isRetainNotes()
    {
        return retainNotes;
    }

    public void setRetainNotes( boolean retainNotes )
    {
        this.retainNotes = retainNotes;
    }

    public Note getNotes()
    {
        return notes;
    }

    public void setNotes( Note notes )
    {
        this.notes = notes;
    }

    public Cost getDebris()
    {
        Cost debris = new Cost( iron, metal, kryptonite, spice );
        return ( debris.isEmpty() ? null : debris );
    }

    public void setDebris( Cost debris )
    {
        if( debris == null )
        {
            iron = 0;
            metal = 0;
            kryptonite = 0;
            spice = 0;
        }
        else
        {
            iron = debris.getIron();
            metal = debris.getMetal();
            kryptonite = debris.getKryptonite();
            spice = debris.getSpice();
        }
    }

    public void update( Planet planet )
    {
        // don't overwrite newer versions
        if( planet.getUpdateTime() > getUpdateTime() )
        {
            this.name = planet.name;
            this.account = planet.account;
            this.hasAsteroid = planet.hasAsteroid;
            this.isEvent = planet.isEvent;
            this.position = planet.position;
            this.owner = planet.owner;
            this.updateTime = planet.updateTime;
            this.iron = planet.iron;
            this.metal = planet.metal;
            this.kryptonite = planet.kryptonite;
            this.spice = planet.spice;
        }
    }

    @Override
    public boolean equals( Object obj )
    {
        // super establishes equality based on ID
        // if it says they are equal, they are
        boolean rv = super.equals( obj );
        if( !rv && obj instanceof Planet )
        {
            Planet that = ( Planet )obj;
            rv = account.equals( that.account ) && position == that.position;
            if( owner == null )
            {
                rv &= ( that.owner == null );
            }
            else
            {
                rv &= owner.equals( that.owner );
            }
        }
        return rv;
    }

    @Override
    public int hashCode()
    {
        return ( account.hashCode() << 21 ) + position;
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append( Position.createFromId( position ).toString() );
        if(name != null) {
            sb.append( ' ' );
            sb.append( name );
        }
        return sb.toString();
    }


}
