/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

/**
 * @author graf
 *
 */
public class Note
{
    private String text = "";

    public Note()
    {
    }

    public String getText()
    {
        return text;
    }

    public void setText( String text )
    {
        this.text = ( text != null ) ? text : "";
    }

    @Override
    public String toString()
    {
        String result = null;
        if( text.trim().length() > 0 )
        {
            result = text;
            String[] lines = text.split( "\\n" );
            if( lines.length > 1 )
            {
                StringBuilder sb = new StringBuilder();
                sb.append( "<html>" );
                for( int i = 0; i < lines.length; i++ )
                {
                    if( i > 0 )
                    {
                        sb.append( "<br>" );
                    }
                    sb.append( lines[i] );
                }
                sb.append( "</html>" );
                result = sb.toString();
            }
        }
        return result;
    }
    
    
}
