/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author graf
 *
 */
public class LRUCache<T extends DbObject<T>> extends LinkedHashMap<Long, T>
{
    private static final long serialVersionUID = -580091837318496827L;
    private static final float hashTableLoadFactor = 0.75f;
    private int cacheSize;

    public LRUCache( int cacheSize )
    {
        super( (int)Math.ceil(cacheSize / hashTableLoadFactor) + 1, hashTableLoadFactor );
        this.cacheSize = cacheSize;
    }

    @Override 
    protected boolean removeEldestEntry (Map.Entry<Long, T> eldest) 
    {
        return size() > cacheSize; 
    }
    
}
