/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

/**
 * @author graf
 *
 */
public abstract class DbObject<T>
{
    private Long id;

    public Long getId()
    {
        return id;
    }

    public void setId( Long id )
    {
        this.id = id;
    }

    @Override
    public boolean equals( Object obj )
    {
        // Objects of the same type with the same ID can be considered equal
        // this is must be enforced by the Dao.find() methods
        boolean rv = false;
        if( getClass().isInstance( obj ) )
        {
            @SuppressWarnings("unchecked")
			DbObject<T> that = (DbObject<T>)obj;
            if( id != null && that.id != null )
            {
                rv = id.longValue() == that.id.longValue();
            }
        }
        return rv;
    }

    public abstract void update(T dbObject);
}
