package siarchive.persistence;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.EtchedBorder;

import siarchive.DataManager;
import siarchive.MainFrame;
import siarchive.reports.ReportText;

public class DbInfoBox extends JDialog
{
    private static final long serialVersionUID = 4449017221348079404L;

    /**
     *
     */
    public DbInfoBox( MainFrame parent )
    {
        super( parent );
        enableEvents( AWTEvent.WINDOW_EVENT_MASK );
        this.setTitle( "DbInfo" );

        DataManager dataManager = parent.getDataManager();
        JPanel contentPane = ( JPanel )getContentPane();
        contentPane.setLayout( new BorderLayout() );
        contentPane.setBorder( BorderFactory.createEtchedBorder( EtchedBorder.LOWERED ) );

        JPanel center = new JPanel( new GridLayout( 9, 1 ) );

        JPanel config = new JPanel( new GridLayout( 1, 2 ) );
        center.add( config );
        config.add( new ReportText( dataManager.getI18nText( "DbInfo.config" ) ) );
        config.add( new ReportText( dataManager.getConfigFile() ) );

        JPanel dbPath = new JPanel( new GridLayout( 1, 2 ) );
        center.add( dbPath );
        dbPath.add( new ReportText( dataManager.getI18nText( "DbInfo.dbpath" ) ) );
        dbPath.add( new ReportText( dataManager.getDbName() ) );

        center.add( new ReportText( dataManager.getI18nText( "DbInfo.contents" ) ) );

        JPanel contents;
        contents = new JPanel( new GridLayout( 1, 2 ) );
        center.add( contents );
        contents.add( new ReportText( dataManager.getI18nText( "DbInfo.alliances" ) ) );
        ReportText count = new ReportText();
        try
        {
            count.setText( Long.toString( dataManager.getCount( Alliance.class ) ) );
        }
        catch( Exception ex )
        {
            parent.showErrorInfo( ex );
        }
        count.setHorizontalAlignment( SwingConstants.RIGHT );
        contents.add( count );
        contents = new JPanel( new GridLayout( 1, 2 ) );
        center.add( contents );
        contents.add( new ReportText( dataManager.getI18nText( "DbInfo.blackHoles" ) ) );
        count = new ReportText();
        try
        {
            count.setText( Long.toString( dataManager.getCount( BlackHole.class ) ) );
        }
        catch( Exception ex )
        {
            parent.showErrorInfo( ex );
        }
        count.setHorizontalAlignment( SwingConstants.RIGHT );
        contents.add( count );
        contents = new JPanel( new GridLayout( 1, 2 ) );
        center.add( contents );
        contents.add( new ReportText( dataManager.getI18nText( "DbInfo.players" ) ) );
        count = new ReportText();
        try
        {
            count.setText( Long.toString( dataManager.getCount( Player.class ) ) );
        }
        catch( Exception ex )
        {
            parent.showErrorInfo( ex );
        }
        count.setHorizontalAlignment( SwingConstants.RIGHT );
        contents.add( count );
        contents = new JPanel( new GridLayout( 1, 2 ) );
        center.add( contents );
        contents.add( new ReportText( dataManager.getI18nText( "DbInfo.planets" ) ) );
        count = new ReportText();
        try
        {
            count.setText( Long.toString( dataManager.getCount( Planet.class ) ) );
        }
        catch( Exception ex )
        {
            parent.showErrorInfo( ex );
        }
        count.setHorizontalAlignment( SwingConstants.RIGHT );
        contents.add( count );
        contents = new JPanel( new GridLayout( 1, 2 ) );
        center.add( contents );
        contents.add( new ReportText( dataManager.getI18nText( "DbInfo.spyReports" ) ) );
        count = new ReportText();
        try
        {
            count.setText( Long.toString( dataManager.getCount( SpyReport.class ) ) );
        }
        catch( Exception ex )
        {
            parent.showErrorInfo( ex );
        }
        count.setHorizontalAlignment( SwingConstants.RIGHT );
        contents.add( count );
        contents = new JPanel( new GridLayout( 1, 2 ) );
        center.add( contents );
        contents.add( new ReportText( dataManager.getI18nText( "DbInfo.battleReports" ) ) );
        count = new ReportText();
        try
        {
            count.setText( Long.toString( dataManager.getCount( BattleReport.class ) ) );
        }
        catch( Exception ex )
        {
            parent.showErrorInfo( ex );
        }
        count.setHorizontalAlignment( SwingConstants.RIGHT );
        contents.add( count );

        JPanel lower = new JPanel( new FlowLayout( FlowLayout.CENTER, 4, 4 ) );
        JButton button = new JButton( "Ok" );
        button.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent e )
            {
                close();
            }
        } );
        lower.add( button );
        getRootPane().setDefaultButton( button );

        contentPane.add( center, BorderLayout.CENTER );
        contentPane.add( lower, BorderLayout.SOUTH );
        pack();
    }

    protected void processWindowEvent( WindowEvent e )
    {
        if( e.getID() == WindowEvent.WINDOW_CLOSING )
        {
            close();
        }
        super.processWindowEvent( e );
    }

    protected void close()
    {
        dispose();
    }

}
