/****************************************
 *  COPYRIGHT (C) 2012
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import java.sql.SQLException;

/**
 * @author graf
 *
 */
public class DatabaseException extends SQLException
{
    private static final long serialVersionUID = 7196454903878741002L;

    /**
     * 
     */
    public DatabaseException()
    {
    }

    /**
     * @param reason
     */
    public DatabaseException( String reason )
    {
        super( reason );
    }

    /**
     * @param cause
     */
    public DatabaseException( Throwable cause )
    {
        super( cause );
    }

    /**
     * @param reason
     * @param SQLState
     */
    public DatabaseException( String reason, String SQLState )
    {
        super( reason, SQLState );
    }

    /**
     * @param reason
     * @param cause
     */
    public DatabaseException( String reason, Throwable cause )
    {
        super( reason, cause );
    }

    /**
     * @param reason
     * @param SQLState
     * @param vendorCode
     */
    public DatabaseException( String reason, String SQLState, int vendorCode )
    {
        super( reason, SQLState, vendorCode );
    }

    /**
     * @param reason
     * @param sqlState
     * @param cause
     */
    public DatabaseException( String reason, String sqlState, Throwable cause )
    {
        super( reason, sqlState, cause );
    }

    /**
     * @param reason
     * @param sqlState
     * @param vendorCode
     * @param cause
     */
    public DatabaseException( String reason, String sqlState, int vendorCode,
                    Throwable cause )
    {
        super( reason, sqlState, vendorCode, cause );
    }

}
