/****************************************
 *  COPYRIGHT (C) 2021
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

import com.fasterxml.jackson.jr.ob.JSON;

import siarchive.components.Fleet;
import siarchive.components.Position;
import siarchive.components.Ship;

/**
 * @author graf
 *
 */
public class BlackHole extends DbObject<BlackHole>
{
    private Long account;
    private int position;
    private boolean setup;
    private int level;
    private boolean attacked;
    private long updateTime;
    private long upgradeTime;

    private long power;
    private Fleet ships = new Fleet();

    private long spice;
    private long emblems;
    private long stars;

    public BlackHole() {}

    public Long getAccount() {
        return account;
    }

    public void setAccount( Long account ) {
        this.account = account;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition( int position ) {
        this.position = position;
    }

    public boolean isSetup() {
        return setup;
    }

    public void setSetup( boolean setup ) {
        this.setup = setup;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel( int level ) {
        this.level = level;
    }

    public boolean isAttacked() {
        return attacked;
    }

    public void setAttacked( boolean attacked ) {
        this.attacked = attacked;
    }

    public long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime( long updateTime ) {
        this.updateTime = updateTime;
    }

    public long getUpgradeTime() {
        return upgradeTime;
    }

    public void setUpgradeTime( long upgradeTime ) {
        this.upgradeTime = upgradeTime;
    }

    public long getPower() {
        return power;
    }

    public void setPower( long power ) {
        this.power = power;
    }

    public Fleet getShips() {
        return ships;
    }

    public String getShipsAsJson() {
        String result = null;
        try {
            result = JSON.std.asString(ships);
        }
        catch(IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setShips( Map<Ship, Long> ships ) {
        this.ships.clear();
        this.ships.putAll(ships);
    }

    public void setShips( String shipsAsJson ) {
        try {
            Map<String, Object> raw = JSON.std.mapFrom(shipsAsJson);
            Map<Ship, Long> ships = new TreeMap<>();
            for(Map.Entry<String, Object> entry : raw.entrySet()) {
                Ship ship = Ship.valueOf(entry.getKey());
                long number = ((Number)entry.getValue()).longValue();
                ships.put(ship, Long.valueOf(number));
            }
            setShips(ships);
        }
        catch(IOException e) {
            e.printStackTrace();
        }
    }

    public long getSpice() {
        return spice;
    }

    public void setSpice( long spice ) {
        this.spice = spice;
    }

    public long getEmblems() {
        return emblems;
    }

    public void setEmblems( long emblems ) {
        this.emblems = emblems;
    }

    public long getStars() {
        return stars;
    }

    public void setStars( long stars ) {
        this.stars = stars;
    }

    public void update( BlackHole blackhole )
    {
        // don't overwrite newer versions
        if( blackhole.getUpdateTime() > getUpdateTime() )
        {
            this.account = blackhole.account;
            this.attacked = blackhole.attacked;
            this.emblems = blackhole.emblems;
            this.level = blackhole.level;
            this.position = blackhole.position;
            this.power = blackhole.power;
            this.setup = blackhole.setup;
            this.ships.clear();
            this.ships.putAll(blackhole.ships);
            this.spice = blackhole.spice;
            this.stars = blackhole.stars;
            this.updateTime = blackhole.updateTime;
            this.upgradeTime = blackhole.upgradeTime;
        }
    }

    @Override
    public boolean equals( Object obj )
    {
        // super establishes equality based on ID
        // if it says they are equal, they are
        boolean rv = super.equals( obj );
        if( !rv && obj instanceof BlackHole )
        {
            BlackHole that = ( BlackHole )obj;
            rv = account.equals( that.account ) && position == that.position;
        }
        return rv;
    }

    @Override
    public int hashCode()
    {
        return ( account.hashCode() << 21 ) + position;
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append( Position.createFromId( position ).toString() );
        return sb.toString();
    }


}
