/****************************************
 *  COPYRIGHT (C) 2012, 2023
 *  Holger Graf
 ****************************************/

package siarchive.persistence;

import siarchive.json.JSONTags;

/**
 * @author graf
 *
 */
public class BattleReport extends Report<BattleReport> implements Notable<BattleReport> {
    private String attacker;

    private String defender;

    public String getAttacker() {
        return attacker;
    }

    public void setAttacker( String attacker ) {
        this.attacker = attacker;
    }

    public String getDefender() {
        return defender;
    }

    public void setDefender( String defender ) {
        this.defender = defender;
    }

    public boolean isJSONData() {
        return (data.indexOf(JSONTags.reportType_BattleReport) >= 0);
    }

    public void update( BattleReport report ) {
        super.update(report);
        this.attacker = report.attacker;
        this.defender = report.defender;
    }

}
