/****************************************
 *  COPYRIGHT (C) 2010
 *  Holger Graf
 ****************************************/
package siarchive.persistence;



/**
 * @author graf
 *
 */
public class Alliance extends DbObject<Alliance> implements Notable<Alliance>
{
    private Long account;
    private long allianceId = -1L;
    private String name;
    private String tag;
    private long updateTime;
    private boolean retainNotes;
    private Note notes;
    
    public Alliance()
    {
        super();
        name = "";
    }
    
    public Alliance( String name )
    {
        this.name = name;
    }

    public Long getAccount()
    {
        return account;
    }

    public void setAccount( Long account )
    {
        this.account = account;
    }

    public long getAllianceId() {
		return allianceId;
	}

	public void setAllianceId(long allianceId) {
		this.allianceId = allianceId;
	}

	public String getName()
    {
        return name;
    }

    public void setName( String name )
    {
        this.name = name;
    }

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

    public boolean isRetainNotes()
    {
        return retainNotes;
    }

    public void setRetainNotes( boolean retainNotes )
    {
        this.retainNotes = retainNotes;
    }

    public long getUpdateTime()
    {
        return updateTime;
    }

    public void setUpdateTime( long updateTime )
    {
        this.updateTime = updateTime;
    }

    public Note getNotes()
    {
        return notes;
    }

    public void setNotes( Note notes )
    {
        this.notes = notes;
    }

    public void update( Alliance alliance )
    {
        // don't overwrite newer versions
        if( alliance.getUpdateTime() > getUpdateTime() )
        {
            this.name = alliance.name;
            this.account = alliance.account;
            // do not update an invalid playerId
            if( alliance.allianceId >= 0 )
            {
                this.allianceId = alliance.allianceId;
            }
            String tag = alliance.getTag();
            if( tag != null && tag.length() > 0 )
            {
                this.tag = tag;
            }
            this.updateTime = alliance.getUpdateTime();
        }
    }

    @Override
    public boolean equals( Object obj )
    {
        // super establishes equality based on ID
        // if it says they are equal, they are
        boolean rv = super.equals( obj );
        if( !rv && obj instanceof Alliance )
        {
            Alliance that = ( Alliance )obj;
            rv = account.equals( that.account ) && ( allianceId == that.allianceId );
        }
        return rv;
    }

    @Override
    public int hashCode()
    {
        return ( account.hashCode() << 16 ) + Long.valueOf( allianceId ).hashCode();
    }

    @Override
    public String toString()
    {
        return getName();
    }
    
}
