/****************************************
 *  COPYRIGHT (C) 2008
 *  Holger Graf
 ****************************************/
package siarchive.persistence;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import siarchive.DataManager;
import siarchive.components.Flavor;
import siarchive.i18n.Language;

/**
 * @author graf
 *
 */
public class Account extends DbObject<Account> implements Comparable<Account>
{
    private String name;
    private boolean defaultAccount;
    private int index;

    private Language language = Language.english;
    private Flavor flavor = Flavor.retro;
    private boolean isOutpost = false;

    public Account()
    {
        super();
    }

    /**
     * @param id
     */
    public Account( String name, boolean isDefault )
    {
        this.name = name;
        this.defaultAccount = isDefault;
    }

    public Account( Account other )
    {
        assign( other );
    }

    public String getName()
    {
        return this.name;
    }

    public void setName( String name )
    {
        this.name = name;
    }

    public boolean isDefault()
    {
        return this.defaultAccount;
    }

    public void setDefault( boolean isDefault )
    {
        this.defaultAccount = isDefault;
    }

    /**
     * @return the language
     */
    public Language getLanguage()
    {
        return language;
    }

    /**
     * @param language the language to set
     */
    public void setLanguage( Language language )
    {
        this.language = language;
    }

    public Flavor getFlavor() {
        return flavor;
    }

    public void setFlavor( Flavor flavor ) {
        this.flavor = flavor;
    }

    public int getIndex()
    {
        return index;
    }

    public void setIndex( int index )
    {
        this.index = index;
    }

    public boolean isOutpost() {
        return isOutpost;
    }

    public void setOutpost( boolean isOutpost ) {
        this.isOutpost = isOutpost;
    }

    public ResourceBundle getResourceBundle()
    {
        ResourceBundle resources = null;
        try
        {
            resources = ResourceBundle.getBundle( DataManager.resourcePath, language.getLocale() );
        }
        catch( NullPointerException ex )
        {
        }
        catch( MissingResourceException ex )
        {
        }
        return resources;
    }

    public void update( Account account )
    {
        this.name = account.name;
        this.defaultAccount = account.defaultAccount;
        this.index = account.index;
        this.language = account.language;
        this.flavor = account.flavor;
        this.isOutpost = account.isOutpost;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return name;
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals( Object obj )
    {
        boolean rv = false;
        if( obj instanceof Account )
        {
            rv = name.equals( ( (Account)obj ).name );
        }
        return rv;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode()
    {
        return name.hashCode();
    }

    /**
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo( Account o )
    {
        return name.compareTo( o.name );
    }

    private void assign( Account other )
    {
        setId( other.getId() );
        this.defaultAccount = other.defaultAccount;
        this.index = other.index;
        this.language = other.language;
        this.flavor = other.flavor;
    }

}
