/****************************************
 *  COPYRIGHT (C) 2018
 *  Holger Graf
 ****************************************/
package siarchive.json.spyreport;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;

import siarchive.json.PlanetType;
import siarchive.tools.EscapeUtils;

/**
 * @author graf
 *
 */
public class PlanetBean {

    private long id;
    private String coords;
    private PlanetType type;
    private String name;
    private List<Long> resources;
    private long energy;
    private List<Long> storage;
    // buildings, ships, defenses and research switch types
    private Map<String, LevelBean> buildings;
    private Map<String, LevelBean> ships;
    private Map<String, LevelBean> defense;
    private Map<String, LevelBean> researches;
    private TeleporterBean teleporter;
    private PlanetBean astro;


    public PlanetBean() {}


    public long getId() {
        return id;
    }


    public void setId( long id ) {
        this.id = id;
    }


    public String getCoords() {
        return coords;
    }


    public void setCoords( String coords ) {
        this.coords = coords;
    }


    public PlanetType getType() {
        return type;
    }


    public void setType( PlanetType type ) {
        this.type = type;
    }


    public String getName() {
        return name;
    }


    public void setName( String name ) {
        this.name = EscapeUtils.unescapeHtml4(name);
    }


    public List<Long> getResources() {
        return resources;
    }


    public void setResources( List<Long> resources ) {
        this.resources = resources;
    }


    public long getEnergy() {
        return energy;
    }


    public void setEnergy( long energy ) {
        this.energy = energy;
    }


    public List<Long> getStorage() {
        return storage;
    }


    public void setStorage( List<Long> storage ) {
        this.storage = storage;
    }


    public Map<String, LevelBean> getBuildings() {
        return buildings;
    }


    public void setBuildings( Object buildings ) throws JSONObjectException, IOException {
        this.buildings = null;
        if(buildings instanceof Map) {
            this.buildings = JSON.std.beanFrom(LevelMap.class, JSON.std.asString(buildings));
        }
    }


    public Map<String, LevelBean> getShips() {
        return ships;
    }


    public void setShips( Object ships ) throws JSONObjectException, IOException {
        this.ships = null;
        if(ships instanceof Map) {
            this.ships = JSON.std.beanFrom(LevelMap.class, JSON.std.asString(ships));
        }
    }


    public Map<String, LevelBean> getDefense() {
        return defense;
    }


    public void setDefense( Object defense ) throws JSONObjectException, IOException {
        this.defense = null;
        if(defense instanceof Map) {
            this.defense = JSON.std.beanFrom(LevelMap.class, JSON.std.asString(defense));
        }
    }


    public Map<String, LevelBean> getResearches() {
        return researches;
    }


    public void setResearches( Object researches ) throws JSONObjectException, IOException {
        this.researches = null;
        if(researches instanceof Map) {
            this.researches = JSON.std.beanFrom(LevelMap.class, JSON.std.asString(researches));
        }
    }


    public TeleporterBean getTeleporter() {
        return teleporter;
    }


    public void setTeleporter( TeleporterBean teleporter ) {
        this.teleporter = teleporter;
    }


    public PlanetBean getAstro() {
        return astro;
    }


    public void setAstro( Object astro ) throws JSONObjectException, IOException {
        this.astro = null;
        if(astro instanceof Map) {
            this.astro = JSON.std.beanFrom(PlanetBean.class, JSON.std.asString(astro));
        }
    }

}
